<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" exclude-result-prefixes="car m"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:car="http://www.example.com/xmlns/car"
  xmlns:m="http://www.example.com/xmlns/manufacturer">

  <xsl:output method="html" encoding="UTF-8" />
  <xsl:key name="cars" match="car:model" use="@m:id" />

  <xsl:template match="/">
    <html>
    <body>
      <h1>Samochody</h1>
      <xsl:apply-templates select="/car:cars/m:manufacturers" />
    </body>
    </html>
  </xsl:template>

  <xsl:template match="m:manufacturers">
    <xsl:for-each select="m:manufacturer">
      <h2><xsl:value-of select="@m:name" /></h2>
      <p><i>Kraj: <xsl:value-of select="@m:country" /></i></p>
      <xsl:for-each select="key('cars', @m:id)">
        <ul>
          <li>
            <xsl:value-of select="@car:name" />
            <xsl:text> (</xsl:text>
            <xsl:value-of select="@car:year" />
            <xsl:text>)</xsl:text>
          </li>
        </ul>
      </xsl:for-each>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
