<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <xsl:variable name="manufacturers"
       select="document('14list06.xml')/manufacturers" />

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="cars">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="model">
    <xsl:value-of select="@name" />
    <xsl:text> </xsl:text>
    <xsl:value-of select="@year" />
    <xsl:text> (</xsl:text>
    <xsl:value-of select="$manufacturers/manufacturer[@id =
                          current()/@manufacturer]/@name" />
    <xsl:text>)&#xA;</xsl:text>
   </xsl:template>
</xsl:stylesheet>
