<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" version="4.0" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <xsl:variable name="config" select="document('14list02.xml')" />

  <xsl:template match="/">
    <html>
    <body>
    <xsl:apply-templates />
    </body>
    </html>
  </xsl:template>

  <xsl:template match="cars">
    <table bgcolor="{$config/config/table/@bgcolor}">
    <xsl:apply-templates />
    </table>
  </xsl:template>

  <xsl:template match="model">
    <tr>
      <xsl:choose>
        <xsl:when test="position() mod 2 = 1">
          <xsl:attribute name="bgcolor">
            <xsl:value-of select="$config/config/row/@bgcolor" />
          </xsl:attribute>
        </xsl:when>
        <xsl:when test="position() mod 2 = 0">
          <xsl:attribute name="bgcolor">
            <xsl:value-of select="$config/config/altrow/@bgcolor" />
          </xsl:attribute>
        </xsl:when>
      </xsl:choose>
      <td><xsl:value-of select="@name" /></td>
      <td><xsl:value-of select="year" /></td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
