<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />
  <xsl:strip-space elements="*" />

  <xsl:variable name="extensions">
    <ext ext="doc">dokument Word</ext>
    <ext ext="dwg">rysunek AutoCad</ext>
    <ext ext="xml">dokument XML</ext>
    <ext ext="xsl">arkusz stylów XSL</ext>
  </xsl:variable>

  <xsl:template match="/">
    <xsl:apply-templates />
  </xsl:template>

  <xsl:template match="folder">
    <xsl:value-of select="concat('&lt;',@name,'&gt;&#xA;')" />
    <xsl:apply-templates />
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>

  <xsl:template match="file">
    <xsl:variable name="ext" select="substring-after(.,'.')" />
    <xsl:value-of select="concat(., '&#x20;')" />
    <xsl:if test="$extensions/ext[@ext=$ext]">
      <xsl:value-of select="concat('(',$extensions/ext[@ext=$ext],')')" />
    </xsl:if>
    <xsl:text>&#xA;</xsl:text>
  </xsl:template>
</xsl:stylesheet>
