<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="text" encoding="UTF-8" />

  <xsl:template match="/">
    Nieskończoność = Nieskończoność? <xsl:value-of select="1 div 0 = 2 div 0" />
    -Nieskończoność = -Nieskończoność? <xsl:value-of select="-1 div 0 = -2 div 0" />
    0 = -0? <xsl:value-of select="0 = -0" />
    NaN = NaN? <xsl:value-of select="number('xyz') = number('abc')" />

    Konwersje:
    <xsl:for-each select="datatypes/*">
       <xsl:value-of select="." /> (<xsl:value-of select="name()" />)
       number(): <xsl:value-of select="number(.)" />
       boolean(): <xsl:value-of select="boolean(.)" />
       string(): <xsl:value-of select="string(.)" />
       <xsl:choose>
         <xsl:when test="name() = 'number'">
           number(string()): <xsl:value-of select="number(string(.))" />
           number(boolean()): <xsl:value-of select="number(boolean(.))" />
         </xsl:when>
         <xsl:when test="name() = 'boolean'">
           boolean(string()): <xsl:value-of select="boolean(string(.))" />
           boolean(number())): <xsl:value-of select="boolean(number(.))" />
         </xsl:when>
         <xsl:when test="name() = 'string'">
           string(number()): <xsl:value-of select="string(number(.))" />
           string(boolean()): <xsl:value-of select="string(boolean(.))" />
         </xsl:when>
       </xsl:choose>
       <xsl:text>&#xA;    </xsl:text>
    </xsl:for-each>
  </xsl:template>
</xsl:stylesheet>
