<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" version="4.0" encoding="UTF-8" />

  <xsl:attribute-set name="table">
    <xsl:attribute name="bgcolor">#ff9999</xsl:attribute>
    <xsl:attribute name="width">75%</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="tableheader">
    <xsl:attribute name="bgcolor">#ffffcc</xsl:attribute>
  </xsl:attribute-set>

  <xsl:attribute-set name="tablerow">
    <xsl:attribute name="bgcolor">#ffcccc</xsl:attribute>
  </xsl:attribute-set>

  <xsl:param name="sortkey">name</xsl:param>
  <xsl:param name="order">ascending</xsl:param>

  <xsl:template match="/">
    <html>
    <body>
      <xsl:apply-templates>
        <xsl:with-param name="sortkey" select="$sortkey" />
        <xsl:with-param name="order" select="$order" />
      </xsl:apply-templates>
    </body>
    </html>
  </xsl:template>

  <xsl:template match="cheeses">
    <xsl:param name="sortkey">name</xsl:param>
    <xsl:param name="order">ascending</xsl:param>
    <table xsl:use-attribute-sets="table">
      <xsl:call-template name="cheeseheader" />
      <xsl:apply-templates select="cheese">
        <xsl:sort select="attribute::*[name() = $sortkey]"
                  order="{$order}" />
      </xsl:apply-templates>
    </table>
  </xsl:template>

  <xsl:template name="cheeseheader">
    <tr xsl:use-attribute-sets="tableheader">
      <td>Nazwa</td>
      <td>Kraj</td>
      <td>Rodzaj</td>
    </tr>
  </xsl:template>

  <xsl:template match="cheese">
    <tr xsl:use-attribute-sets="tablerow">
      <td><xsl:value-of select="@name" /></td>
      <td><xsl:value-of select="@country" /></td>
      <td><xsl:value-of select="@type" /></td>
    </tr>
  </xsl:template>
</xsl:stylesheet>
