<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

  <xsl:output method="html" version="4.0" encoding="UTF-8" />
  <xsl:strip-space elements="article body" />

  <xsl:template match="/">
    <html>
      <body>
        <xsl:apply-templates />
      </body>
    </html>
  </xsl:template>

  <xsl:template match="article">
    <xsl:call-template name="info" />
    <h2>Wstęp</h2>
    <p><xsl:apply-templates select="intro" /></p>
    <h2>Spis treści</h2>
    <xsl:apply-templates mode="toc" />
    <hr />
    <xsl:apply-templates mode="body" />
  </xsl:template>

  <xsl:template name="info">
    <h1><xsl:value-of select="title" /></h1>
    <p>
      Autor: <i>
        <xsl:value-of select="author/@firstname" />
        <xsl:text> </xsl:text>
        <xsl:value-of select="author/@lastname" />
      </i>, 
      dn.<xsl:value-of select="@date" />
    </p>
  </xsl:template>

  <xsl:template match="*" />
</xsl:stylesheet>
