﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

//using System.Windows.Media;
using System.ComponentModel;
using System.Windows.Input;

using Windows.Media;
using Windows.UI;
using KoloryUA.Model;

namespace KoloryUA.ModelWidoku
{
    public class EdycjaKoloru : INotifyPropertyChanged
    {
        private Kolor kolor = Ustawienia.Czytaj();

        public byte R
        {
            get
            {
                return kolor.R;
            }
            set
            {
                kolor.R = value;
                OnPropertyChanged("R");
                OnPropertyChanged("Color");
                (Resetuj as RelayCommand).OnCanExecuteChanged();
            }
        }

        public byte G
        {
            get
            {
                return kolor.G;
            }
            set
            {
                kolor.G = value;
                OnPropertyChanged("G");
                OnPropertyChanged("Color");
                (Resetuj as RelayCommand).OnCanExecuteChanged();
            }
        }

        public byte B
        {
            get
            {
                return kolor.B;
            }
            set
            {
                kolor.B = value;
                OnPropertyChanged("B");
                OnPropertyChanged("Color");
                (Resetuj as RelayCommand).OnCanExecuteChanged();
            }
        }

        public event PropertyChangedEventHandler PropertyChanged;

        private void OnPropertyChanged(params string[] nazwyWłasności)
        {
            if (PropertyChanged != null)
            {
                foreach (string nazwaWłasności in nazwyWłasności)
                    PropertyChanged(this, new PropertyChangedEventArgs(nazwaWłasności));
            }
        }

        private ICommand resetujCommand;

        public ICommand Resetuj
        {
            get
            {
                if(resetujCommand==null)
                {                    
                    resetujCommand = new RelayCommand(
                        argument =>
                        {
                            R = 0;
                            G = 0;
                            B = 0;
                        },
                        argument => (R != 0) || (G != 0) || (B != 0)
                        );
                }
                return resetujCommand;
            }
        }

        private ICommand zapiszCommand;

        public ICommand Zapisz
        {
            get
            {
                if (zapiszCommand == null)
                    zapiszCommand = new RelayCommand(
                        argument =>
                        {
                            Ustawienia.Zapisz(kolor);
                        });
                return zapiszCommand;
            }
        }

        /*
        //bardzo brzydkie, niezgodne z MVVM polecenie!!!!!!!!
        public ICommand ZamknijOkno
        {
            get
            {
                return new RelayCommand(
                    argument => { (argument as System.Windows.Window).Close(); });
            }
        }
        */

        public Color Color
        {
            get
            {
                return kolor.ToColor();                
            }
        }
    }

    static class Rozszerzenia
    {
        public static Color ToColor(this Kolor kolor)
        {
            //return Color.FromRgb(kolor.R, kolor.G, kolor.B);
            return new Color() {A = 255, R = kolor.R, G = kolor.G, B = kolor.B};
        }
    }
}
