//
//  WalksPageViewModel.cs
//  TrackMyWalks ViewModels
//
//  Created by Steven F. Daniel on 22/08/2016.
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System.Collections.ObjectModel;
using System.Threading.Tasks;
using TrackMyWalks.Models;
using TrackMyWalks.Services;
using Xamarin.Forms;

namespace TrackMyWalks.ViewModels
{
	public class WalksPageViewModel : WalkBaseViewModel
	{
		ObservableCollection<WalkEntries> _walkEntries;

		public ObservableCollection<WalkEntries> walkEntries
		{
			get { return _walkEntries; }
			set
			{
				_walkEntries = value;
				OnPropertyChanged();
			}
		}

		public WalksPageViewModel(IWalkNavService navService) : base(navService)
		{
			walkEntries = new ObservableCollection<WalkEntries>();
		}

		public override async Task Init()
		{
			await LoadWalkDetails();
		}

		public async Task LoadWalkDetails()
		{
			// Check to see if we are already processing our Walk Trail Items
			if (IsProcessBusy) { return; }

			// If we aren't currently processing, we need to initialise our variable to true
			IsProcessBusy = true;

			// Add a temporary timer, so that we can see our progress indicator working
			await Task.Delay(1000);

			await Task.Factory.StartNew(() =>
			{
				walkEntries = new ObservableCollection<WalkEntries>() {
				new WalkEntries {
                    Title  = "10-milowy szlak wzdu strumienia, Margaret River",
                    Notes  = "10-milowy szlak wzdu strumienia zaczyna si w Rotary Park w pobliu Old Kate, czyli " +
                             "starej lokomotywy stojcej w pnocnej czci Margaret River. ",
                    Latitude    = -33.9727604,
                    Longitude   = 115.0861599,
                    Kilometers  = 7.5,
                    Distance    = 0,
                    Difficulty  = "redni",
                    ImageUrl    = "http://trailswa.com.au/media/cache/media/images/trails/_mid/" +
                                  "FullSizeRender1_600_480_c1.jpg"
                },
                new WalkEntries {
                    Title  = "Szlak Ancient Empire, Dolina Gigantw",
                    Notes  = "Ancient Empire to 450-metrowy szlak pord " +
                             "gigantycznych drzew, wrd ktrych znajduj si popularne skate olbrzymy zwane " +
                             "Grandma Tingle.",
                    Latitude  = -34.9749188,
                    Longitude   = 117.3560796,
                    Kilometers = 450,
                    Distance   = 0,
                    Difficulty = "Wysoki",
                    ImageUrl   = "http://trailswa.com.au/media/cache/media/images/trails/_mid/" +
                                 "Ancient_Empire_534_480_c1.jpg"
                },
				};
			});

			// Re-initialise our process busy value back to false
			IsProcessBusy = false;
		}

		Command _createNewWalk;
		public Command CreateNewWalk
		{
			get
			{
				return _createNewWalk
					?? (_createNewWalk = new Command(async () =>
													 await NavService.NavigateToViewModel<WalkEntryViewModel, WalkEntries>(null)));
			}
		}

		Command<WalkEntries> _trailDetails;
		public Command<WalkEntries> WalkTrailDetails
		{
			get
			{
				return _trailDetails
					?? (_trailDetails = new Command<WalkEntries>(async (trailDetails) =>
																 await NavService.NavigateToViewModel<WalksTrailViewModel, WalkEntries>(trailDetails)));
			}
		}
	}
}