//
//  TrackMyWalks.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System.Threading.Tasks;
using TrackMyWalks.Services;
using TrackMyWalks.ViewModels;
using Xamarin.Forms;

namespace TrackMyWalks
{
	public class App : Application
	{
		public App()
		{
			// sprawdzenie systemu operacyjnego
			if (Device.OS == TargetPlatform.Android)
			{
				// strona gwna aplikacji
				MainPage = new SplashPage();
			}
			else if (Device.OS == TargetPlatform.iOS)
			{
				// ustawienie strony gwnej aplikacji
				var walksPage = new NavigationPage(new WalksPage()
				{
					Title = "Track My Walks - iOS"
				});

				// ustawienie koloru tekstu paska nawigacyjnego i koloru ta
				walksPage.BarBackgroundColor = Color.FromHex("#440099");
				walksPage.BarTextColor = Color.White;

				// deklaracja interfejsu DependencyService
				var navService = DependencyService.Get<IWalkNavService>() as WalkNavService;
				navService.navigation = walksPage.Navigation;

				// rejstracja mapowa midzy modelami widokw i widokami (stronami)
				navService.RegisterViewMapping(typeof(WalksPageViewModel), typeof(WalksPage));
				navService.RegisterViewMapping(typeof(WalkEntryViewModel), typeof(WalkEntryPage));
				navService.RegisterViewMapping(typeof(WalksTrailViewModel), typeof(WalkTrailPage));
				navService.RegisterViewMapping(typeof(DistTravelledViewModel), typeof(DistanceTravelledPage));

				// ustawienie strony gwnej na walksPage
				MainPage = walksPage;
			}
		}

		protected override void OnStart()
		{
			// procedura obsugi uruchamiania aplikacji
		}

		protected override void OnSleep()
		{
			// procedura obsugi usypiania aplikacji
		}

		protected override void OnResume()
		{
			// procedura obsugi wznawiania dziaania aplikacji
		}
	}
}