//
//  WalksPageViewModel.cs
//  TrackMyWalks ViewModels
//
//  Autor: Steven F. Daniel, 22.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System.Collections.ObjectModel;
using TrackMyWalks.Models;

namespace TrackMyWalks.ViewModels
{
	public class WalksPageViewModel : WalkBaseViewModel
	{
		ObservableCollection<WalkEntries> _walkEntries;
		public ObservableCollection<WalkEntries> walkEntries
		{
			get { return _walkEntries; }
			set
			{
				_walkEntries = value;
				OnPropertyChanged();
			}
		}

		public WalksPageViewModel()
		{
			walkEntries = new ObservableCollection<WalkEntries>() {
				new WalkEntries {
					Title = "10-milowy szlak wzdu strumienia, Margaret River",
Notes = " 10-milowy szlak wzdu strumienia zaczyna si w
  Rotary Park w pobliu Old Kate, czyli " +
  " starej lokomotywy stojcej w pnocnej czci Margaret River. ",
					Latitude    = -33.9727604,
					Longitude   = 115.0861599,
					Kilometers  = 7.5,
					Distance    = 0,
					Difficulty  = "Medium",
					ImageUrl    = "http://trailswa.com.au/media/cache/media/images/trails/_mid/" +
								  "FullSizeRender1_600_480_c1.jpg"
				},
				new WalkEntries {
					Title = "Szlak Ancient Empire, Dolina Gigantw",
Notes = " Ancient Empire to 450-metrowy szlak pord
gigantycznych drzew, wrd ktrych znajduj si " +
"popularne skate olbrzymy zwane Grandma Tingle.",
					Latitude  = -34.9749188,
					Longitude   = 117.3560796,
					Kilometers = 450,
					Distance   = 0,
					Difficulty = "Hard",
					ImageUrl   = "http://trailswa.com.au/media/cache/media/images/trails/_mid/" +
								 "Ancient_Empire_534_480_c1.jpg"
				},
			};
		}
	}
}

