//
//  WalkNavService.cs
//  TrackMyWalks Navigation Service Class
//
//  Autor: Steven F. Daniel, 03.09.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System;
using Xamarin.Forms;
using System.Collections.Generic;
using System.Threading.Tasks;
using System.Reflection;
using System.Linq;
using TrackMyWalks.ViewModels;
using TrackMyWalks.Services;

[assembly: Dependency(typeof(WalkNavService))]
namespace TrackMyWalks.Services
{
	public class WalkNavService : IWalkNavService
	{
		public INavigation navigation { get; set; }
		readonly IDictionary<Type, Type> _viewMapping = new Dictionary<Type, Type>();

		// rejestracja widoku modelu i widoku w sowniku
		public void RegisterViewMapping(Type viewModel, Type view)
		{
			_viewMapping.Add(viewModel, view);
		}

		// Instance method that allows us to move back to the previous page
		public async Task PreviousPage()
		{
			// sprawdzenie, czy mona przej do poprzedniej strony
			if (navigation.NavigationStack != null &&
				navigation.NavigationStack.Count > 0)
			{
				await navigation.PopAsync(true);
			}
		}

		// metoda obiektowa pozwalajca wrci do gwnej strony WalksPage
		public async Task BackToMainPage()
		{
			await navigation.PopToRootAsync(true);
		}

		// metoda obiektowa pozwalajca przej do wybranego modelu widoku w 
		// sowniku viewMapping
		public async Task NavigateToViewModel<ViewModel, WalkParam>(WalkParam parameter)
			where ViewModel : WalkBaseViewModel
		{
			Type viewType;

			if (_viewMapping.TryGetValue(typeof(ViewModel), out viewType))
			{
				var constructor = viewType.GetTypeInfo()
					.DeclaredConstructors
					.FirstOrDefault(dc => dc.GetParameters().Count() <= 0);

				var view = constructor.Invoke(null) as Page;
				await navigation.PushAsync(view, true);
			}

			if (navigation.NavigationStack.Last().BindingContext is WalkBaseViewModel<WalkParam>)
				await ((WalkBaseViewModel<WalkParam>)(navigation.NavigationStack.Last().BindingContext)).Init(parameter);
		}
	}
}