package wzorceproj.posrednik.gumomat;

import java.rmi.*;
 
public class AutomatSprzedającyMonitorTest {
 
   public static void main(String[] args) {
      String[] lokalizacja = {"rmi://katowice.automatysprzedajace.com/automatsprzedajacy",
                              "rmi://wroclaw.automatysprzedajace.com/automatsprzedajacy",
                              "rmi://warszawa.automatysprzedajace.com/automatsprzedajacy"}; 

      if (args.length >= 0)
        {
            lokalizacja = new String[1];
            lokalizacja[0] = "rmi://" + args[0] + "/automatsprzedajacy";
        }
      
      AutomatSprzedającyMonitor[] monitor = new AutomatSprzedającyMonitor[lokalizacja.length];
      
      
      for (int i=0;i < lokalizacja.length; i++) {
         try {
                 AutomatSprzedającyZdalny automat = 
                  (AutomatSprzedającyZdalny) Naming.lookup(lokalizacja[i]);
                 monitor[i] = new AutomatSprzedającyMonitor(automat);
            System.out.println(monitor[i]);
           } catch (Exception e) {
               e.printStackTrace();
           }
      }
 
      for (int i=0; i < monitor.length; i++) {
         monitor[i].raport();
      }
   }
}
