package wzorceproj.polecenie.superpilotlambda;

//
// To jest klasa obiektu wywołującego
//
public class SuperPilot {
   Polecenie[] poleceniaWłącz;
   Polecenie[] poleceniaWyłącz;
 
   public SuperPilot() {
      poleceniaWłącz = new Polecenie[7];
      poleceniaWyłącz = new Polecenie[7];
 
      for (int i = 0; i < 7; i++) {
         poleceniaWłącz[i] = () -> {};
         poleceniaWyłącz[i] = () -> {};
      }
   }
  
   public void ustawPolecenie(int gniazdo, Polecenie polecenieWłącz, Polecenie polecenieWyłącz) {
      poleceniaWłącz[gniazdo] = polecenieWłącz;
      poleceniaWyłącz[gniazdo] = polecenieWyłącz;
   }
 
   public void wciśniętoPrzyciskWłącz(int gniazdo) {
      poleceniaWłącz[gniazdo].wykonaj();
   }
 
   public void wciśniętoPrzyciskWyłącz(int gniazdo) {
      poleceniaWyłącz[gniazdo].wykonaj();
   }
  
   public String toString() {
      StringBuffer stringBuff = new StringBuffer();
      stringBuff.append("\n------ SuperPilot -------\n");
      for (int i = 0; i < poleceniaWłącz.length; i++) {
         stringBuff.append("[gniazdo " + i + "] " + poleceniaWłącz[i].getClass().getName()
            + "    " + poleceniaWyłącz[i].getClass().getName() + "\n");
      }
      return stringBuff.toString();
   }
}
