package wzorceproj.iterator.laczeniebiznesowi;

import java.util.Iterator;
import java.util.ArrayList;
 
public class Kelnerka {
   Menu naleśnikarniaMenu;
   Menu obiadowoMenu;
 
   public Kelnerka(Menu naleśnikarniaMenu, Menu obiadowoMenu) {
      this.naleśnikarniaMenu = naleśnikarniaMenu;
      this.obiadowoMenu = obiadowoMenu;
   }
   
   // --- dodane 30.12.2016 - brak w oryginalnych kodach
   public void drukujMenu(int withNewConstructs) {
      ArrayList<PozycjaMenu> pozycjeŚniadaniowe = ((NaleśnikarniaMenu) naleśnikarniaMenu).pobierzPozycjeMenu();
      //pMenu.forEach(m -> drukujPozycjeMenu(m));
      for (PozycjaMenu m : pozycjeŚniadaniowe) {
         drukujPozycjeMenu(m);
      }
      
      PozycjaMenu[] pozycjeLunch = ((ObiadowoMenu) obiadowoMenu).pobierzPozycjeMenu();
      for (PozycjaMenu m : pozycjeLunch) {
         drukujPozycjeMenu(m);
      }
   }
   
   public void drukujPozycjeMenu(PozycjaMenu pozycjaMenu) {
      System.out.print(pozycjaMenu.pobierzNazwa() + ", ");
      System.out.print(pozycjaMenu.pobierzCena() + " -- ");
      System.out.println(pozycjaMenu.pobierzOpis());
   }
   // ---
 
   public void drukujMenu() {
      Iterator<PozycjaMenu> naleśnikarniaIterator = naleśnikarniaMenu.utwórzIterator();
      Iterator<PozycjaMenu> obiadowoIterator = obiadowoMenu.utwórzIterator();

      System.out.println("MENU\n----\nŚNIADANIA:");
      drukujMenu(naleśnikarniaIterator);
      System.out.println("\nLUNCH");
      drukujMenu(obiadowoIterator);
   }
 
   private void drukujMenu(Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu menuItem = iterator.next();
         System.out.print(menuItem.pobierzNazwa() + ", ");
         System.out.print(menuItem.pobierzCena() + " -- ");
         System.out.println(menuItem.pobierzOpis());
      }
   }
 
   public void drukujMenuWegetariańskie() {
      System.out.println("\n MENU WEGETARIAŃSKIE\n----\nŚNIADANIA:");
      drukujMenuWegetariańskie(naleśnikarniaMenu.utwórzIterator());
      System.out.println("\nLUNCH");
      drukujMenuWegetariańskie(obiadowoMenu.utwórzIterator());
   }
 
   public boolean czyJestWegetariańska(String name) {
      Iterator<PozycjaMenu> naleśnikarniaIterator = naleśnikarniaMenu.utwórzIterator();
      if (czyJestWegetariańska(name, naleśnikarniaIterator)) {
         return true;
      }
      Iterator<PozycjaMenu> obiadowoIterator = obiadowoMenu.utwórzIterator();
      if (czyJestWegetariańska(name, obiadowoIterator)) {
         return true;
      }
      return false;
   }


   private void drukujMenuWegetariańskie(Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu pozycjaMenu = iterator.next();
         if (pozycjaMenu.czyJestWegetariańska()) {
            System.out.print(pozycjaMenu.pobierzNazwa());
            System.out.println("\t\t" + pozycjaMenu.pobierzCena());
            System.out.println("\t" + pozycjaMenu.pobierzOpis());
         }
      }
   }

   private boolean czyJestWegetariańska(String nazwa, Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu menuItem = iterator.next();
         if (menuItem.pobierzNazwa().equals(nazwa)) {
            if (menuItem.czyJestWegetariańska()) {
               return true;
            }
         }
      }
      return false;
   }
}
