package wzorceproj.stan.gumomatstangra;

import java.util.Random;

public class StanJestMoneta implements Stan {
   Random losowaWygrana = new Random(System.currentTimeMillis());
   AutomatSprzedający automatSprzedający;
 
   public StanJestMoneta(AutomatSprzedający automatSprzedający) {
      this.automatSprzedający = automatSprzedający;
   }
  
   public void włóżMonetę() {
      System.out.println("Nie możesz włożyć więcej niż jednej monety");
   }
 
   public void zwróćMonetę() {
      System.out.println("Moneta zwrócona");
      automatSprzedający.ustawStan(automatSprzedający.pobierzStanNieMaMonety());
   }
 
   public void przekręćGałkę() {
      System.out.println("Obróciłeś gałkę...");
      int winner = losowaWygrana.nextInt(10);
      if ((winner == 0) && (automatSprzedający.pobierzLiczba() > 1)) {
         automatSprzedający.ustawStan(automatSprzedający.pobierzStanWygrana());
      } else {
         automatSprzedający.ustawStan(automatSprzedający.pobierzStanGumaSprzedana());
      }
   }

   public void wydaj() {
      System.out.println("Nie wydano gumy");
   }
    
   public void napełnij() { }
 
   public String toString() {
      return "czekam na obrócenie gałki";
   }
}
