package wzorceproj.stan.gumomat;

public class AutomatSprzedający {
 
   final static int BRAK_GUM = 0;
   final static int NIE_MA_MONETY = 1;
   final static int JEST_MONETA = 2;
   final static int GUMA_SPRZEDANA = 3;
 
   int stan = BRAK_GUM;
   int liczba = 0;
  
   public AutomatSprzedający(int liczba) {
      this.liczba = liczba;
      if (liczba > 0) {
         stan = NIE_MA_MONETY;
      }
   }
  
   public void włóżMonetę() {
      if (stan == JEST_MONETA) {
         System.out.println("Nie możesz włożyć więcej niż jednej monety");
      } else if (stan == NIE_MA_MONETY) {
         stan = JEST_MONETA;
         System.out.println("Moneta przyjęta");
      } else if (stan == BRAK_GUM) {
         System.out.println("Nie możesz włożyć monety, gdy automat jest pusty");
      } else if (stan == GUMA_SPRZEDANA) {
           System.out.println("Proszę czekać na wydanie gumy");
      }
   }

   public void zwróćMonentę() {
      if (stan == JEST_MONETA) {
         System.out.println("Moneta zwrócona");
         stan = NIE_MA_MONETY;
      } else if (stan == NIE_MA_MONETY) {
         System.out.println("Nie włożyłeś monety");
      } else if (stan == GUMA_SPRZEDANA) {
         System.out.println("Niestety, nie można zwrócić monety po przekręceniu gałki");
      } else if (stan == BRAK_GUM) {
           System.out.println("Nie włożyłeś monety");
      }
   }
 
   public void przekręćGałkę() {
      if (stan == GUMA_SPRZEDANA) {
         System.out.println("Nie dostaniesz gumy tylko dlatego, że przekręciłeś drugi raz!");
      } else if (stan == NIE_MA_MONETY) {
         System.out.println("Zanim przekręcisz gałkę, wrzuć monetę");
      } else if (stan == BRAK_GUM) {
         System.out.println("Przekręciłeś gałkę, ale automat jest pusty");
      } else if (stan == JEST_MONETA) {
         System.out.println("Obróciłeś gałkę...");
         stan = GUMA_SPRZEDANA;
         wydaj();
      }
   }
 
   private void wydaj() {
      if (stan == GUMA_SPRZEDANA) {
         System.out.println("Wypada guma");
         liczba = liczba - 1;
         if (liczba == 0) {
            System.out.println("Ups, koniec gum!");
            stan = BRAK_GUM;
         } else {
            stan = NIE_MA_MONETY;
         }
      } else if (stan == NIE_MA_MONETY) {
         System.out.println("Najpierw zapłać");
      } else if (stan == BRAK_GUM) {
         System.out.println("Nie wydano gumy");
      } else if (stan == JEST_MONETA) {
         System.out.println("Nie wydano gumy");
      }
   }
 
   public void napełnij(int liczbaGum) {
      this.liczba = liczbaGum;
      stan = NIE_MA_MONETY;
   }

   public String toString() {
      StringBuffer result = new StringBuffer();
      result.append("\nAutomaty Sprzedające SA");
      result.append("\nWolnostojący automat do sprzedaży gum Gumomat Model #2004 Java\n");
      result.append("Zapas gum: " + liczba );
      result.append("\nBieżący stan automatu: ");
      if (stan == BRAK_GUM) {
         result.append("brak gum");
      } else if (stan == NIE_MA_MONETY) {
         result.append("oczekiwanie na włożenie monety");
      } else if (stan == JEST_MONETA) {
         result.append("oczekiwanie na przekręcenie gałki");
      } else if (stan == GUMA_SPRZEDANA) {
         result.append("wydawanie gumy");
      }
      result.append("\n");
      return result.toString();
   }
}


