package wzorceproj.metodaszablonowa.listy;

import java.util.AbstractList;

// Klasa AbstractList dostarcza minimalną implementację interfejsu List,
// starając się w ten sposób zmniejszyć wysiłek konieczny do zaimplementowania
// tego interfejsu z wykorzystaniem źródła danych zapewniającego "dostęp 
// swobodny" (czyli takiego jak na przykład tablica).

// Aby zaimplementować listę, która nie zapewnia możliwości modyfikacji,
// programista musi jedynie rozszerzyć tę klasę i dostarczyć implementacji 
// dwóch metod: get(int) oraz size(). 
// get(int indeks) to abstrakcyjna metoda klasy AbstractList.
// size() jest abstrakcyjną metodą klasy AbstractCollection.
// subList(int indeksOd, int indeksDo) zwraca widok fragmenty listy zawartego 
// pomiędzy dwoma indeksami, indeksOd (włącznie) i indeksDo.

public class MojaListaŁańcuchów extends AbstractList<String> {
   private String[] mojaLista;
   MojaListaŁańcuchów(String[] strings) {
      mojaLista = strings;
   }
   @Override
   public String get(int indeks) {
      return mojaLista[indeks];
   }
   @Override
   public String set(int indeks, String elem) {
      String staryŁańcuch = mojaLista[indeks];
      mojaLista[indeks] = elem;
      return staryŁańcuch;
   }
   @Override
   public int size() {
      return mojaLista.length;
   }
}