package wzorceproj.iterator.laczeniebiznesowjavaiterator;

import java.util.Iterator;

public class Kelnerka {
   Menu naleśnikarniaMenu;
   Menu obiadowoMenu;
 
   public Kelnerka(Menu naleśnikarniaMenu, Menu obiadowoMenu) {
      this.naleśnikarniaMenu = naleśnikarniaMenu;
      this.obiadowoMenu = obiadowoMenu;
   }

   public void drukujMenu() {
      Iterator<PozycjaMenu> naleśnikarniaIterator = naleśnikarniaMenu.utwórzIterator();
      Iterator<PozycjaMenu> obiadowoIterator = obiadowoMenu.utwórzIterator();

      System.out.println("MENU\n----\nŚNIADANIA:");
      drukujMenu(naleśnikarniaIterator);
      System.out.println("\nLUNCH:");
      drukujMenu(obiadowoIterator);

   }
 
   private void drukujMenu(Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu pozycjaMenu = iterator.next();
         System.out.print(pozycjaMenu.pobierzNazwa() + ", ");
         System.out.print(pozycjaMenu.pobierzCena() + " -- ");
         System.out.println(pozycjaMenu.pobierzOpis());
      }
   }
 
   public void drukujMenuWegetariańskie() {
      drukujMenuWegetariańskie(naleśnikarniaMenu.utwórzIterator());
      drukujMenuWegetariańskie(obiadowoMenu.utwórzIterator());
   }
 
   public boolean czyJestWegetariańska(String nazwa) {
      Iterator<PozycjaMenu> śniadaniaIterator = naleśnikarniaMenu.utwórzIterator();
      if (czyJestWegetariańska(nazwa, śniadaniaIterator)) {
         return true;
      }
      Iterator<PozycjaMenu> obiadyIterator = obiadowoMenu.utwórzIterator();
      if (czyJestWegetariańska(nazwa, obiadyIterator)) {
         return true;
      }
      return false;
   }


   private void drukujMenuWegetariańskie(Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu pozycjaMenu = iterator.next();
         if (pozycjaMenu.czyJestWegetariańska()) {
            System.out.print(pozycjaMenu.pobierzNazwa());
            System.out.println("\t\t" + pozycjaMenu.pobierzCena());
            System.out.println("\t" + pozycjaMenu.pobierzOpis());
         }
      }
   }

   private boolean czyJestWegetariańska(String nazwa, Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu pozycjaMenu = iterator.next();
         if (pozycjaMenu.pobierzNazwa().equals(nazwa)) {
            if (pozycjaMenu.czyJestWegetariańska()) {
               return true;
            }
         }
      }
      return false;
   }

}
