package wzorceproj.fasada.kinodomowe;

public class FasadaKinaDomowego {
   Wzmacniacz wzmacniacz;
   Tuner tuner;
   OdtwarzaczMultimediów odtwarzacz;
   Projektor projektor;
   OświetlenieKinowe oświetlenie;
   Ekran ekran;
   MaszynkaPopcorn popcorn;
 
   public FasadaKinaDomowego(Wzmacniacz wzmaczniacz, 
             Tuner tuner, 
             OdtwarzaczMultimediów odtwarzacz, 
             Projektor projektor, 
             Ekran ekran,
             OświetlenieKinowe oświetlenie,
             MaszynkaPopcorn popcorn) {
 
      this.wzmacniacz = wzmaczniacz;
      this.tuner = tuner;
      this.odtwarzacz = odtwarzacz;
      this.projektor = projektor;
      this.ekran = ekran;
      this.oświetlenie = oświetlenie;
      this.popcorn = popcorn;
   }
 
   public void odtwarzajFilm(String film) {
      System.out.println("Przygotuj się na seans filmowy...");
      popcorn.włącz();
      popcorn.przygotujPopcorn();
      oświetlenie.ściemniaj(10);
      ekran.wDół();
      projektor.włącz();
      projektor.trybSzerokoekranowy();
      wzmacniacz.włącz();
      wzmacniacz.ustawOdtwarzacz(odtwarzacz);
      wzmacniacz.ustawDźwiękPrzestrzenny();
      wzmacniacz.ustawGłośność(5);
      odtwarzacz.włącz();
      odtwarzacz.odtwarzaj(film);
   }
 
 
   public void zakończOdtwarzanieFilmu() {
      System.out.println("Koniec seansu, wyłączam kino domowe...");
      popcorn.wyłącz();
      oświetlenie.włącz();
      ekran.wGórę();
      projektor.wyłącz();
      wzmacniacz.wyłącz();
      odtwarzacz.zatrzymaj();
      odtwarzacz.wyłącz();
   }

   public void odtwarzajRadio(double frequency) {
      System.out.println("Nastawianie częstotliwości do słuchania...");
      tuner.włącz();
      tuner.ustawCzęstotliwość(frequency);
      wzmacniacz.włącz();
      wzmacniacz.ustawGłośność(5);
      wzmacniacz.ustawTuner(tuner);
   }

   public void zakończOdtwarzanieRadia() {
      System.out.println("Wyłączam tuner...");
      tuner.wyłącz();
      wzmacniacz.wyłącz();
   }
}
