package wzorceproj.posrednik.gumomat;

import java.util.Random;

public class StanJestMoneta implements Stan {
	private static final long serialVersionUID = 2L;
	Random randomWinner = new Random(System.currentTimeMillis());
	transient AutomatSprzedający automatSprzedający;
 
	public StanJestMoneta(AutomatSprzedający automatSprzedający) {
		this.automatSprzedający = automatSprzedający;
	}
  
	public void włóżMonetę() {
		System.out.println("Nie możesz włożyć więcej niż jednej monety");
	}
 
	public void zwróćMonetę() {
		System.out.println("Moneta zwrócona");
		automatSprzedający.ustawStan(automatSprzedający.pobierzStanNieMaMonety());
	}
 
	public void przekręćGałkę() {
		System.out.println("Obróciłeś gałkę...");
		int wygrana = randomWinner.nextInt(10);
		if (wygrana == 0) {
			automatSprzedający.ustawStan(automatSprzedający.pobierzStanWygrana());
		} else {
			automatSprzedający.ustawStan(automatSprzedający.pobierzStanGumaSprzedana());
		}
	}

    public void wydaj() {
        System.out.println("Nie wydano gumy");
    }
 
	public String toString() {
		return "czekam na obrócenie gałki";
	}
}
