package wzorceproj.polaczone.djview;
    
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class DJWidok implements ActionListener,  ObserwatorUderzeń, ObserwatorBPM {
    BeatModelInterfejs model;
    KontrolerInterfejs kontroler;
    JFrame widokFrame;
    JPanel widokPanel;
    BeatBar beatBar;
    JLabel bpmWyjścieLabel;
    JFrame sterowanieFrame;
    JPanel sterowaniePanel;
    JLabel bpmLabel;    
    JTextField bpmTextField;
    JButton ustawBPMButton;
    JButton zwiększBPMButton;
    JButton zmniejszBPMButton;
    JMenuBar menuBar;
    JMenu menu;
    JMenuItem startMenuItem;
    JMenuItem stopMenuItem;

    public DJWidok(KontrolerInterfejs kontroler, BeatModelInterfejs model) {	
        this.kontroler = kontroler;
        this.model = model;
        model.zarejestrujObserwator((ObserwatorUderzeń)this);
        model.zarejestrujObserwator((ObserwatorBPM)this);
    }
    
    public void utwórzWidok() {
        // Tworzenie elementów sterujących biblioteki Swing
        widokPanel = new JPanel(new GridLayout(1, 2));
        widokFrame = new JFrame("Widok");
        widokFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        widokFrame.setSize(new Dimension(150, 120));
        bpmWyjścieLabel = new JLabel("wyłączone", SwingConstants.CENTER);
        beatBar = new BeatBar();
        beatBar.setValue(0);
        JPanel bpmPanel = new JPanel(new GridLayout(2, 1));
        bpmPanel.add(beatBar);
        bpmPanel.add(bpmWyjścieLabel);
        widokPanel.add(bpmPanel);
        widokFrame.getContentPane().add(widokPanel, BorderLayout.CENTER);
        widokFrame.pack();
        widokFrame.setVisible(true);
    }
  
  
    public void utwórzElementySterujące() {
        // Tworzenie elementów sterujących biblioteki Swing
        JFrame.setDefaultLookAndFeelDecorated(true);
        sterowanieFrame = new JFrame("Sterowanie");
        sterowanieFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        sterowanieFrame.setSize(new Dimension(100, 80));

        sterowaniePanel = new JPanel(new GridLayout(1, 2));

        menuBar = new JMenuBar();
        menu = new JMenu("DJ");
        startMenuItem = new JMenuItem("Start");
        menu.add(startMenuItem);
        startMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                kontroler.start();
            }
        });

        // można zmienić na....
        // startMenuItem.addActionListener((event) -> kontroler.start());
        stopMenuItem = new JMenuItem("Stop");
        menu.add(stopMenuItem); 

        stopMenuItem.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                kontroler.stop();
            }
        });

        // można zmienić na....
        // stopMenuItem.addActionListener((event) -> kontroler.stop());
        JMenuItem exit = new JMenuItem("Zamknij");

        exit.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });

        // można zmienić na....
        // exit.addActionListener((event) -> System.exit(0));

        menu.add(exit);
        menuBar.add(menu);
        sterowanieFrame.setJMenuBar(menuBar);

        bpmTextField = new JTextField(2);
        bpmLabel = new JLabel("Podaj BPM:", SwingConstants.RIGHT);
        ustawBPMButton = new JButton("Ustaw");
        ustawBPMButton.setSize(new Dimension(10,40));
        zwiększBPMButton = new JButton(">>");
        zmniejszBPMButton = new JButton("<<");
        ustawBPMButton.addActionListener(this);
        zwiększBPMButton.addActionListener(this);
        zmniejszBPMButton.addActionListener(this);

        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));

        buttonPanel.add(zmniejszBPMButton);
        buttonPanel.add(zwiększBPMButton);

        JPanel enterPanel = new JPanel(new GridLayout(1, 2));
        enterPanel.add(bpmLabel);
        enterPanel.add(bpmTextField);
        JPanel insideControlPanel = new JPanel(new GridLayout(3, 1));
        insideControlPanel.add(enterPanel);
        insideControlPanel.add(ustawBPMButton);
        insideControlPanel.add(buttonPanel);
        sterowaniePanel.add(insideControlPanel);
        
        bpmLabel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));
        bpmWyjścieLabel.setBorder(BorderFactory.createEmptyBorder(5,5,5,5));

        sterowanieFrame.getRootPane().setDefaultButton(ustawBPMButton);
        sterowanieFrame.getContentPane().add(sterowaniePanel, BorderLayout.CENTER);

        sterowanieFrame.pack();
        sterowanieFrame.setVisible(true);
    }

    public void aktywujStopMenuItem() {
        stopMenuItem.setEnabled(true);
    }

    public void dezaktywujStopMenuItem() {
        stopMenuItem.setEnabled(false);
    }

    public void aktywujStartMenuItem() {
        startMenuItem.setEnabled(true);
    }

    public void dezaktywujStartMenuItem() {
        startMenuItem.setEnabled(false);
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == ustawBPMButton) {
            int bpm = 90;
            String bpmTekst = bpmTextField.getText();
            if (bpmTekst == null || bpmTekst.contentEquals("")) {
                bpm = 90;
            } else {
                bpm = Integer.parseInt(bpmTextField.getText());
            }
            kontroler.ustawBPM(bpm);
        } else if (event.getSource() == zwiększBPMButton) {
            kontroler.zwiększBPM();
        } else if (event.getSource() == zmniejszBPMButton) {
            kontroler.zmniejszBPM();
        }
    }

    public void aktualizujBPM() {
        int bpm = model.pobierzBPM();
        if (bpm == 0) {
            bpmWyjścieLabel.setText("wyłączone");
        } else {
            bpmWyjścieLabel.setText("Bieżąca wartość BPM: " + model.pobierzBPM());
        }
    }
  
    public void aktualizujBeat() {
        beatBar.setValue(100);
    }
}
