package wzorceproj.polaczone.djview;

import java.util.*;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import java.io.*;
import javax.sound.sampled.Line;

public class BeatModel implements BeatModelInterfejs, Runnable {
   List<ObserwatorUderzeń> obserwatoryUderzeń = new ArrayList<ObserwatorUderzeń>();
   List<ObserwatorBPM> obserwatoryBPM = new ArrayList<ObserwatorBPM>();
   int bpm = 90;
   Thread wątek;
   boolean stop = false;
   Clip klip;

   public void inicjuj() {
      try {
         File resource = new File("clap.wav");
         klip = (Clip) AudioSystem.getLine(new Line.Info(Clip.class));
         klip.open(AudioSystem.getAudioInputStream(resource));
      }
      catch(Exception ex) {
         System.out.println("Błąd: Nie można znaleźć klipu!");
         System.out.println(ex);
      }
   }

   public void start() {
      bpm = 90;
      powiadomObserwatoryUderzeń();
      wątek = new Thread(this);
      stop = false;
      wątek.start();
   }

   public void stop() {
      zatrzymajBeat();
      stop = true;
      bpm = 0;
   }

   public void run() {
      while (!stop) {
         odtwarzajBeat();
         powiadomObserwatoryUderzeń();
         try {
            Thread.sleep(60000/pobierzBPM());
         } catch (Exception e) {}
      }
   }

   public void ustawBPM(int bpm) {
      this.bpm = bpm;
      powiadomObserwatoryBPM();
   }

   public int pobierzBPM() {
      return bpm;
   }

   public void zarejestrujObserwator(ObserwatorUderzeń o) {
      obserwatoryUderzeń.add(o);
   }

   public void powiadomObserwatoryUderzeń() {
      for(int i = 0; i < obserwatoryUderzeń.size(); i++) {
         ObserwatorUderzeń obserwator = (ObserwatorUderzeń)obserwatoryUderzeń.get(i);
         obserwator.aktualizujBeat();
      }
   }

   public void zarejestrujObserwator(ObserwatorBPM o) {
      obserwatoryBPM.add(o);
   }

   public void powiadomObserwatoryBPM() {
      for(int i = 0; i < obserwatoryBPM.size(); i++) {
         ObserwatorBPM obserwator = (ObserwatorBPM)obserwatoryBPM.get(i);
         obserwator.aktualizujBPM();
      }
   }

   public void wyrejestrujObserwator(ObserwatorUderzeń o) {
      int i = obserwatoryUderzeń.indexOf(o);
      if (i >= 0) {
         obserwatoryUderzeń.remove(i);
      }
   }

   public void wyrejestrujObserwator(ObserwatorBPM o) {
      int i = obserwatoryBPM.indexOf(o);
      if (i >= 0) {
         obserwatoryBPM.remove(i);
      }
   }

   public void odtwarzajBeat() {
      klip.setFramePosition(0);
      klip.start();
   }
   public void zatrzymajBeat() {
      klip.setFramePosition(0);
      klip.stop();
   }

}

