package wzorceproj.obserwator.stacjameteoobserwator;

import java.util.Observable;
import java.util.Observer;

public class StatystykiPanel implements Observer, PanelInformacyjny {
	private float tempMaks = 0.0f;
	private float tempMin = 200;
	private float tempSuma= 0.0f;
	private int liczbaPomiarów;

	public StatystykiPanel(Observable obserwowalny) {
		obserwowalny.addObserver(this);
	}

	public void update(Observable obserwowalny, Object arg) {
		if (obserwowalny instanceof DanePogodowe) {
			DanePogodowe danePogodowe = (DanePogodowe)obserwowalny;
			float temperatura = danePogodowe.pobierzTemperature();
			tempSuma += temperatura;
			liczbaPomiarów++;

			if (temperatura > tempMaks) {
				tempMaks = temperatura;
			}
 
			if (temperatura < tempMin) {
				tempMin = temperatura;
			}

			wyświetl();
		}
	}

	public void wyświetl() {
		System.out.println("Temperatura średnia / maksymalna / minimalna = " + (tempSuma / liczbaPomiarów)
			+ "/" + tempMaks + "/" + tempMin);
	}
}
