public class GarbageMain {

    public static final int THREADS_NUMBER = 2;
    public static final int ALLOCATION_SIZE = 10_000;

    public static void main(String[] args) throws Exception {
        System.out.println("Przykład alarmu z czujnika...");
        var builder = new ThreadContainer.Builder()
                .addThreadGroup("SensorAlarm-Workers");
        for (int i = 0; i < THREADS_NUMBER; i++) {
            builder.addRunnable(new SensorAlarmWorker(i, ALLOCATION_SIZE));
        }

        var container = builder.build();
        container.startAsDaemon();
        System.out.println("Status uruchomienia systemu alarmowego pojazu:" + container.isStarted() + ", wątki: " + THREADS_NUMBER);
        System.out.println("Naciśnij kodwolny klawisz, aby skończyć!");
        System.out.flush();
        System.in.read();
    }
}
