class MementoMain {
    public static void main(String[] args) {
        System.out.println("Wzorzec Pamiątka, system klimatyzacji");
        var originator = new AirConditionSystemOriginator();
        var careTaker = new AirConditionSystemCareTaker();

        originator.setState("niski");
        var stateLow = originator.saveState(careTaker);
        originator.setState("średni");
        var stateMedium = originator.saveState(careTaker);
        originator.setState("wysoki");
        var stateHigh = originator.saveState(careTaker);

        System.out.printf("""
                Bieżący stan systemu: '%s'%n""", originator.getState());

        originator.restoreState(careTaker.getMemento(stateLow));
        System.out.printf("""
                Przywrócono ustawienie: '%d', bieżący stan systemu: '%s'%n""", stateLow, originator.getState());
    }
}
