class Vehicle {
    private final SystemCache cache = new SystemCache(3);

    void init(){
        cache.addSystem(new BreakSystem("hamulec"));
        cache.addSystem(new EngineSystem("silnik"));
        System.out.println("Vehicle, inicjalizacja bufora:" + systemTypes());
    }

    void addSystem(VehicleSystem s){
        if(!cache.addSystem(s)){
            System.err.println("SystemCache, nieuruchomiony:" + s);
        }
    }

    String systemTypes(){
        return cache.getSystemTypes();
    }

    VehicleSystem getSystemByType(String type){
        return  cache.getSystem(type);
    }

}
