<?php

class IndexControllerTest extends Zend_Test_PHPUnit_ControllerTestCase
{

    protected $_email = "testing_user";
    protected $_password = "testing_password";

    public function setUp()
    {
        $this->bootstrap = new Zend_Application(APPLICATION_ENV, APPLICATION_PATH . '/configs/application.ini');
        parent::setUp();
    }

    public function testRegisterHasFields()
    {
        $this->dispatch("/users/register");
        $this->assertQuery("input[name='first']", "nie znaleziono pola imienia");
        $this->assertQuery("input[name='last']", "nie znaleziono pola nazwiska");
        $this->assertQuery("input[name='email']", "nie znaleziono pola adresu e-mail");
        $this->assertQuery("input[name='password']", "nie znaleziono pola hasła");
        $this->assertQuery("input[name='photo']", "nie znaleziono pola zdjęcia");
        $this->assertQuery("input[name='save']", "nie znaleziono przycisku rejestracji");
    }

    public function testRegisterWorks()
    {
        $this->request->setMethod("POST")
            ->setPost(array(
                "first" => "testing",
                "last" => "testing",
                "email" => $this->_email,
                "password" => $this->_password,
                "save" => "register"
            ));

        $this->dispatch("/users/register");
        $this->assertQueryContentContains("p", "konto zostało utworzone");
    }

    public function testLoginHasFields()
    {
        $this->dispatch("/users/login");
        $this->assertQuery("input[name='email']", "nie znaleziono pola adresu e-mail");
        $this->assertQuery("input[name='password']", "nie znaleziono pola hasła");
        $this->assertQuery("input[name='login']", "nie znaleziono przycisku logowania");
    }

    public function testLoginWorks()
    {
        $this->request
            ->setMethod("POST")
            ->setPost(array(
                "email" => $this->_email,
                "password" => $this->_password,
                "login" => "login"
            ));

        $this->dispatch("/users/login");
        print_r($this->response->getBody());
        $this->assertRedirect($message = "nie przekierowano");
    }


}

