#include "chapter_12.h"
#ifdef SUPPORTS_COROUTINES

#include <gtest/gtest.h>

#include "resumable.h"

#include <limits>
#include <thread>


namespace {

Resumable coroutine() { // To samo co wcześniej
  std::cout << "c1 ";
  co_await std::suspend_always{};
  std::cout << "c2 ";
}

auto coro_factory() { // Tworzenie i zwracanie korutyny.
  auto res = coroutine();
  return res;
}

} // namespace

TEST(PassingCoroutinesAround, ResumeFromDifferentThread) {
  auto r = coro_factory();
  r.resume(); // Wznawianie w funkcji main.

  auto t = std::thread{[r = std::move(r)]() mutable {
    using namespace std::chrono_literals;
    std::this_thread::sleep_for(2s);
    r.resume(); // Wznawianie w wątku.
  }};
  t.join();
}


#endif // SUPPORTS_COROUTINES