#include <array>
#include <gtest/gtest.h>

//
// Ten kod ilustruje migotwanie pamięci podręcznej.
// Zmiana sposobu dostępu do elementów w macierzy
// ma olbrzymi wpływ na wydajność.
//

// Wielkość pamięci podręcznej L1 na dane. Zastąp tę wartość
// wielkością pamięci podręcznej L1 na dane z Twojego komputera
constexpr auto kL1CacheCapacity = 32768u;
constexpr auto kSize = kL1CacheCapacity / sizeof(int);
using MatrixType = std::array<std::array<int, kSize>, kSize>;

auto cache_thrashing_fast(MatrixType& matrix) {
  auto counter = 0;
  for (auto i = 0u; i < kSize; ++i) {
    for (auto j = 0u; j < kSize; ++j) {
      matrix[i][j] = counter++;
    }
  }
}

auto cache_thrashing_slow(MatrixType& matrix) {
  auto counter = 0;
  for (auto i = 0u; i < kSize; ++i) {
    for (auto j = 0u; j < kSize; ++j) {
      matrix[j][i] = counter++; // Powolne z powodu migotania pamięci podręcznej
    }
  }
}

// Używanie pamięci statycznej, ponieważ
// używana macierz może nie zmieścić się na stosie
MatrixType m;

TEST(CacheThrashing, Fast) { cache_thrashing_fast(m); }

TEST(CacheThrashing, Slow) { cache_thrashing_slow(m); }
