// 1: Definicja adresu bazowego układów peryferyjnych
#define PERIPH_BASE        (0x40000000UL)
// 2: Przesunięcie magistrali AHB1
#define AHB1PERIPH_OFFSET  (0x00020000UL)
// 3: Adres bazowy dla układów peryferyjnych AHB1
#define AHB1PERIPH_BASE    (PERIPH_BASE + AHB1PERIPH_OFFSET)
// 4: Przesunięcie portu GPIOA
#define GPIOA_OFFSET       (0x0000UL)
// 5: Adres bazowy GPIOA
#define GPIOA_BASE         (AHB1PERIPH_BASE + GPIOA_OFFSET)
// 6: Przesunięcie rejestru RCC
#define RCC_OFFSET         (0x3800UL)
// 7: Adres bazowy RCC
#define RCC_BASE           (AHB1PERIPH_BASE + RCC_OFFSET)
// 8: Przesunięcie rejestru AHB1EN
#define AHB1EN_R_OFFSET    (0x30UL)
// 9: Adres rejestru AHB1EN
#define RCC_AHB1EN_R  (*(volatile unsigned int *)(RCC_BASE + AHB1EN_R_OFFSET))
// 10: Przesunięcie rejestru trybu
#define MODE_R_OFFSET      (0x00UL)
// 11: Adres rejestru trybu portu GPIOA
#define GPIOA_MODE_R  (*(volatile unsigned int *)(GPIOA_BASE + MODE_R_OFFSET))
// 12: Przesunięcie rejestru danych wyjściowych
#define OD_R_OFFSET   (0x14UL)
// 13: Adres rejestru danych wyjściowych portu GPIOA
#define GPIOA_OD_R    (*(volatile unsigned int *)(GPIOA_BASE + OD_R_OFFSET))
// 14: Maska bitowa do włączania portu GPIOA (bit 0)
#define GPIOAEN       (1U<<0)
// 15: Maska bitowa dla pinu 5. portu  GPIOA
#define PIN5          (1U<<5)
// 16: Alias pinu 5. reprezentujący podłączoną diodę LED
#define LED_PIN       PIN5

// 17: początek funkcji main
int main(void)
{
    //  18: włączenie dostępu do zegara dla portu GPIOA
    RCC_AHB1EN_R |= GPIOAEN;
    GPIOA_MODE_R |= (1U<<10);  //  19: ustawienie bitu 10. na 1
    GPIOA_MODE_R &= ~(1U<<11); //  20: ustawienie bitu 11. na 0
    //  21: początek nieskończonej pętli
    while(1)
    { // 22: przełączenie PA5(LED_PIN)
    	GPIOA_OD_R ^= LED_PIN;
		for(int i = 0; i < 5000000; i++){}

    }  //  23: koniec nieskończonej pętli
	
}  //  24: koniec funkcji main
