#include "gpio_exti.h"


#define GPIOCEN		    (1U<<2)
#define SYSCFGEN		(1U<<14)

void pc13_exti_init(void)
{
	/* Wyłączanie globalnych przerwań */
	__disable_irq();

	/* Włączanie dostępu do zegara dla GPIOC*/
	RCC->AHB1ENR |=GPIOCEN;

	/* Ustawianie pinu PC13 jako wejścia */
	GPIOC->MODER &=~(1U<<26);
	GPIOC->MODER &=~(1U<<27);

	/* Włączanie dostępu do zegara dla SYSCFG */
	RCC->APB2ENR |=SYSCFGEN;

	/* Wybieranie portu PORTC dla EXTI13*/
	SYSCFG->EXTICR[3] |=(1U<<5);

	/* Usuwanie maski EXTI13*/
	EXTI->IMR |=(1U<<13);

	/* Wybieranie wyzwalacza na zboczu opadającym */
	EXTI->FTSR |=(1U<<13);

	/* Włączanie linii EXTI13 w kontrolerze NVIC*/
	NVIC_EnableIRQ(EXTI15_10_IRQn);

	/* Włączanie globalnych przerwań */
	__enable_irq();


}

