#include "adxl345.h"

// Zmienna do przechowywania pojedynczego bajta danych
char data;

// Bufor do przechowywania wielu bajtów danych z ADXL345
uint8_t data_buffer[6];

void adxl_read_address (uint8_t reg)
{
     i2c1_byte_read( ADXL345_DEVICE_ADDR, reg, &data);
}

void adxl_write (uint8_t reg, char value)
{
    char data[1];
    data[0] = value;
    i2c1_burst_write( ADXL345_DEVICE_ADDR, reg,1, data) ;
}

void adxl_read_values (uint8_t reg)
{
    // Wczytywanie 6 bajtów do bufora danych
    i2c1_burst_read(ADXL345_DEVICE_ADDR, reg, 6,(char *)data_buffer);
}

void adxl_init (void)
{
    /* Włączanie I2C */
    i2c1_init();

    /* Odczytywanie DEVID, powinno zwrócić 0xE5*/
    adxl_read_address(ADXL345_REG_DEVID);

    /* Ustawianie zakresu danych na +-4g */
    adxl_write (ADXL345_REG_DATA_FORMAT, ADXL345_RANGE_4G);

    /* Resetowanie wszystkich bitów */
    adxl_write (ADXL345_REG_POWER_CTL, ADXL345_RESET);

    /* Konfigurowanie bitu sterowania zasilaniem */
    adxl_write (ADXL345_REG_POWER_CTL, ADXL345_MEASURE_BIT);
}
