//1: Dołączenie pliku nagłówkowego stm32f4
#include "stm32f4xx.h"
//2: Maska bitowa do włączania portu GPIOA (bit 0)
#define GPIOAEN (1U<<0)
//3: Maska bitowa dla pinu 5. portu GPIOA
#define PIN5 (1U<<5)
//4: Alias dla pinu 5. reprezentujący diodę LED
#define LED_PIN PIN5


int main(void)
{
    //  5: Włączenie dostępu do zegara dla GPIOA
	RCC->AHB1ENR |=  GPIOAEN;

	// 6: Ustawienie PA5 w tryb wyjściowy
	GPIOA->MODER |= (1U<<10);
	GPIOA->MODER &= ~(1U<<11);

    while(1)
    {
    	//  7: Przełączenie stanu PA5
		GPIOA->ODR ^= LED_PIN;
        // 8: Proste opóźnienie
		for(int i=0;i<100000;i++){}

    }

}
