#include "adc.h"

#define GPIOAEN        (1U<<0)
#define ADC1EN         (1U<<8)
#define ADC_CH1        (1U<<0)
#define ADC_SEQ_LEN_1  0x00
#define CR2_ADCON      (1U<<0)
#define CR2_CONT       (1U<<1)
#define CR2_SWSTART    (1U<<30)
#define SR_EOC         (1U<<1)

void pa1_adc_init(void)
{
    /****Konfigurowanie pinu ADC GPIO**/
    /*Włączanie dostępu do zegara dla GPIOA*/
    RCC->AHB1ENR |= GPIOAEN;

    /*Ustawianie PA1 w tryb analogowy*/
    GPIOA->MODER |=(1U<<2);
    GPIOA->MODER |=(1U<<3);

    /****Konfigurowanie modułu ADC**/
    /*Włączanie dostępu do zegara dla modułu ADC*/
    RCC->APB2ENR |=ADC1EN;

    /*Ustawanie początku sekwencji konwersji */
    ADC1->SQR3 = ADC_CH1;

    /*Ustawianie długości sekwencji konwersji */
    ADC1->SQR1 = ADC_SEQ_LEN_1;

    /*Włączanie modułu ADC*/
    ADC1->CR2 |=CR2_ADCON;

}

void start_conversion(void)
{
    /*Włączanie konwersji ciągłej*/
    ADC1->CR2 |=CR2_CONT;

    /*Rozpoczęcie konwersji ADC*/
    ADC1->CR2 |=CR2_SWSTART;
}


uint32_t adc_read(void)
{
    /*Czekanie na ukończenie konwersji*/
    while(!(ADC1->SR & SR_EOC)){}

    /*Odczytywanie przekonwertowanej wartości*/
    return (ADC1->DR);
}
