template< class T, void (T::*F)() >
class callback
{
public:
   callback(T& t) : object(t) {}   // Przypisuje rzeczywisty obiekt do T
   void execute() {(object.*F)();} // Wywouje funkcj zwrotn

private:
   T& object;
};

/* Alternatywne rozwizania
template < class T >
class callback {
public:
   typedef void (T::*Func)();

   callback(T& t, Func func) : object(t), f(func){} // Wie rzeczywisty obiekt
   void operator()() const { (object.*f)(); }       // Wywouje funkcj zwrotn
private:
   T& object;
   Func f;
};

template < class T >
class callback {
public:
   typedef void (T::*Func)();
   callback(T& t, Func func) : object(&t), f(func){} // Wie rzeczywisty obiekt
   void operator()() const { (object->*f)(); }       // Wywouje funkcj zwrotn
private:
   T* object;
   Func f;
};

*/