// Przykad 7.1. Specjalizacja szablonw
//

// Czciowa specjalizacja szablonu z punktu (a) dla typw wskanikowych
template<class T> class X<T*> {/*  */};

// Pena specjalizacja szablonu z punktu (a) dla liczb cakowitych
template<> class X<int> {/*  */};

// Odrbny szablon podstawowy, ktry przecia szablony z punktw (a) i (b).
// Nie jest to czciowa specjalizacja szablonu z punktu (b), poniewa czciowa
// specjalizacja szablonu funkcji nie jest moliwa!
template<class T> void f( T* );           // (d)

// Pena specjalizacja szablonu z punktu (b) dla liczb cakowitych
template<> void f<int>( int );            // (e)

// Zwyka funkcja, ktra przecia szablony z punktw (b), (c) oraz (d),
// ale nie z punktu (e), co wyjanione jest poniej
void f( double );                         // (f)

bool   b;
int    i;
double d;

f( b );        // Wywouje (b) z typem T = bool
f( i, 42, d ); // Wywouje (c) z typem T = int
f( &i );       // Wywouje (d) z typem T = int
f( i );        // Wywouje (e)
f( d );        // Wywouje (f)
