class CallbackBase {
public:
   virtual void operator()() const {};
   virtual ~CallbackBase() = 0;
};

CallbackBase::~CallbackBase() {}

template<typename T>
class Callback : public CallbackBase {
public:
   typedef void (T::*F)();
   Callback( T& t, F f)  : t_(&t), f_(f) {}
   void operator()() const { (t_->*f_)(); }
private:
   T* t_;
   F f_;
};

template<typename T>
Callback<T> make_callback( T& t, void (T::*f) () ) {
   return Callback<T>( t, f );
}

