// Poprawiona wersja kodu opublikowanego pierwotnie w [Hicks00].
//
#include <vector>
#include <map>
#include <algorithm>

// W pierwszym rozwizaniu wprowadziem podstawowe zmiany porzdkujce kod, ale
// zachowaem jego oryginaln struktur. Ta wersja posiada ma dugo 17 wierszy (nawet
// jeli liczysz public oraz private jako wiersze), podczas gdy oryginalny kod
// posiada mia dugo 23 wierszy.
//
namespace Solution1 {
   template<class Iter>
   class sort_idxtbl_pair {
   public:
      void set( const Iter& it, int i ) { it_ = it; i_ = it; }
      bool operator<( const sort_idxtbl_pair& other ) const
      { return *it_ < *other.it_; }
      operator int() const { return i_; }
   private:
      Iter it_;
      int i_;
   };

// Poprawa przejrzystoci najbardziej widoczna jest w tej funkcji. Posiada Liczy ona tylko 5
// wierszy, podczas gdy jej oryginalna wersja a 13. Po kadym wierszu przedstawiam dla
// porwnania kod wersji pierwotnej. Staraj si pisa kod, ktry jest przejrzysty i
// zwizy oraz unikaj niepotrzebnej nadmiernej zoonoci i niejasnoci.
//
   template<class IterIn, class IterOut>
   void sort_idxtbl( IterIn first, IterIn last, IterOut out ) {
      std::vector<sort_idxtbl_pair<IterIn> > v(last-first);
      // int iDst = last-first;
      // typedef std::vector< sort_idxtbl_pair<RAIter> > V;
      // V v(iDst);

   for(int i=0; i < last-first; ++i)
      v[i].set(first+i, i);
      // int i=0;
      // RAIter it = first;
      // V::iterator vit = v.begin();
      // for (i=0; it<last; it++, vit++, i++)
      // (*vit).set(it,i);

   std::sort( v.begin(), v.end() );
      // std::sort(v.begin(), v.end());

   std::copy( v.begin(), v.end(), out );
      // int *pi = pidxtbl;
      // vit = v.begin();
      // for (; vit<v.end(); pi++, vit++)
      // *pi = (*vit).i;
   }
}

// W drugim rozwizaniu uywam klasy pair zamiast tworzy podobn klas pomocnicz.
// Pozwala to skrci rozwizanie z 23 wierszy oryginalnego kodu do 12. 8 z tych
// 12 wierszy jest specyficznych dla rozwizania, pozostae 4 mona bezporednio
// wykorzysta rwnie w innym kontekcie.
namespace Solution2 {
   template<class T, class U>
   struct ComparePair1stDeref {
      bool operator()( const std::pair<T,U>& a, const std::pair<T,U>& b ) const
      { return *a.first < *b.first; }
   };

   template<class IterIn, class IterOut>
   void sort_idxtbl( IterIn first, IterIn last, IterOut out ) {
      std::vector< std::pair<IterIn,int> > s( last-first );
      for( int i=0; i < s.size(); ++i)
         s[i] = std::make_pair(first+i, i );

      std::sort( s.begin(), s.end(), ComparePair1stDeref<IterIn,int>() );

      for(int i=0; i < s.size(); ++i, ++out)
      *out = s[i].second;
   }
}

// Trzecie rozwizanie demonstruje kilka dodatkowych szczegw - uywam w nim
// kontenera map w celu uniknicia odrbnego sortowania, a take funkcji std::transform()
// zamiast samodzielnie pisanej ptli. Kod wci skada si z 13 wierszy, ale
// jest atwiejszy do powtrnego wykorzystania. Wersja ta powoduje wikszy narzut
// pamici  i czasu wykonania, dlatego wyej ceni drugie rozwizanie, jednak w
// tej wersji chciaem zademonstrowa inny sposb podejcia do problemu.
//
namespace Solution3 {
   template<class T>
   struct CompareDeref {
      bool operator()( const T& a, const T& b ) const
      { return *a < *b; }
   };

   template<class T, class U>
   struct Pair2nd {
      const U& operator()( const std::pair<T,U>& a ) const { return a.second; }
   };

   template<class IterIn, class IterOut>
   void sort_idxtbl( IterIn first, IterIn last, IterOut out ) {
      std::multimap<IterIn, int, CompareDerefe<IterIn> > v;
      for( int i=0; first != last; ++i, ++first)
         v.insert( std::make_pair( first, i ) );
      std::transform( v.begin(), v.end(), out, Pair2nd<IterIn const,int>() );
   }
}

// W programie testowym wprowadziem jedynie kosmetyczne zmiany. Do przekazywania
// wyniku uywam dowolnego iteratora wyjciowego zamiast wskanika int*, a take
// uywam bezporednio tablicy rdowej jako kontenera.
//
#include <iostream>

int main() {
   int ai[10] = { 15,12,13,14,18,11,10,17,16,19 };

   std::cout << ################# << std::endl;
   std::vector<int> aidxtbl( 10 );
   // Uywam rnych przestrzeni nazw do testowania poszczeglnych rozwiza
   Solution3::sort_idxtbl( ai, ai+10, aidxtbl.begin() );

   for (int i=0; i<10; i++)
   std::cout << i= << i
             << , aidxtbl[i]= << aidxtbl[i]
             << , ai[aidxtbl[i]]= << ai[aidxtbl[i]]
             << std::endl;
   std::cout << ################# << std::endl;
}
