// Przykad 27.2. Klasa BitBuffer zaimplementowana  za pomoc kontenera vector<bool>.
//
class BitBuffer {
public:
   // Dodaje num bitw rozpoczynajc od bitu p .
   //
   void Append( unsigned char* p, size_t num ) {
      int bits = numeric_limits<unsigned char>::digits;
      for( int i = 0; i < num; ++i) {
         buf_.push_back( *p & (1 << (bits-1 - i%bits)) );
         if( (i+1) % bits == 0 )
            ++p;
      }
   }

   // Zwraca liczb uywanych bitw (pocztkowo zero).
   //
   size_t Size() const {
      return buf_.size();
   }

   // Pobiera num bitw, rozpoczynajc od bitu start (liczc od 0)
   // i zachowuje wynik w miejscu rozpoczynajcym si od bitu dst.
   //
   void Get( size_t start, size_t num, unsigned char* dst ) const {
      int bits = numeric_limits<unsigned char>::digits;
      *dst = 0;
      for( int i = 0; i < num; ++i) {
         *dst |= unsigned char(buf_[start+i]) << (bits-1 - i%bits);
         if( (i+1) % bits == 0 )
            *++dst = 0;
      }
   }
private:
   vector<bool> buf_;
};
