// Przykad 27.1. Klasa BitBuffer zaimplementowana  za pomoc
// kontenera vector<unsigned char>. Trudna, konkretna praca. Uff.
//
class BitBuffer {
public:
   BitBuffer() : buf_(0), size_(0) {}
// Dodaje num bitw rozpoczynajc od bitu p .
//
void Append( unsigned char* p, size_t num ) {
   int bits = numeric_limits<unsigned char>::digits;
   // Pierwszy bajt docelowy wraz z przesuniciem bitw
   int dst = size_ / bits;
   int off = size_ % bits;
   while (buf_.size() < (size_ + num) / bits + 1 )
      buf_.push_back( 0 );
   for( int i = 0; i < (num + bits - 1) / bits; ++i) {
      unsigned char mask = FirstBits(num - bits*i);
   buf_[dst+i] |= (*(p+i) & mask) >> off;
   if( off > 0 )
      buf_[dst+i+1] = (*(p+i) & mask) << (bits - off);
   }
   size_ += num;
}
// Zwraca liczb uywanych bitw (pocztkowo zero).
//
size_t Size() const {
   return size_;
}
// Pobiera num bitw rozpoczynajc od bitu start (liczc od 0)
// i zachowuje wynik w miejscu rozpoczynajcym si od bitu dst.
// Bufor, na ktry wskazuje dst, powinien by przynajmniej o jeden
// bajt wikszy, ni wynosi minimum potrzebne do zapisania num bitw.
//
void Get( size_t start, size_t num, unsigned char* dst ) const {
   int bits = numeric_limits<unsigned char>::digits;
   // Pierwszy bajt rdowy wraz z przesuniciem bitw
   int src = start / bits;
   int off = start % bits;
   for( int i = 0; i < (num + bits - 1)/bits; ++i){
      *(dst+i) = buf_[src+i] << off;
   if( off > 0 )
      *(dst+i) |= buf_[src+i+1] >> (bits - off);
   }
}
private:
   vector<unsigned char> buf_;
   size_t size_;   // w bitach
// Tworzy mask, w ktrej n pierwszych bitw ustawionych jest na 1, a pozostae na 0.
//
unsigned char FirstBits( size_t n ) {
   int num = min( n, numeric_limits<unsigned char>::digits );
   unsigned char b = 0;
   while( num-- > 0 )
      b = (b >> 1) | (1 << (numeric_limits<unsigned char>::digits-1));
   return b;
   }
};
