// Plik x.h
//
class X {
public:
   X() : private_(1){ /*  */ }
   template<class T>
   void f( const T& t ){ /*  */ }
   int Value() { return private_; }
   //
private:
   int private_;
};


// Przykad 15.1. Kamstwa i faszerstwo
//
class X {
   // Zamiast doczenia pliku x.h samodzielnie (i nielegalnie) kopiuje
   // definicj klasy X i dodaje linie takie jak ponisze:
   friend ::Hijack( X& );
};

void Hijack( X& x ){
   x.private_ = 2;      // W tym miejscu zowieszczy miech
}


// Przykad 15.2. Za magia makr
//
#define private public     // Niedozwolone
#include x.h

void Hijack( X& x ){
   x.private_ = 2;         // W tym miejscu zowieszczy miech
}


// Przykad 15.3. Zoliwa prba symulacji ukadu danych obiektu
//
class BaitAndSwitch {    // Szczliwie posiada ten sam ukad danych, co klasa X
public:                  // dlatego mona przekaza obiekt BaitAndSwitch zamiast X
   int notSoPrivate;
};

void f( X& x ) {
   (reinterpret_cast<BaitAndSwitch&>(x)).notSoPrivate = 2;
}            // W tym miejscu zowieszczy miech


// Przykad 15.4. Cwany lis
//
namespace {
   struct Y {};
}
template<>
void X::f( const Y& ){
   private_ = 2;      // W tym miejscu zowieszczy miech
}

void Test() {
   X x;
   cout << x.Value() << endl;      // Wywietla 1
   X.f( Y() );
   cout << x.Value() << endl;      // Wywietla 2
}
