<?php 
/*
Plugin Name: Utworzenie witryny w sieci Multisite
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka demonstruje tworzenie witryn w sieci Multisite.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_action( 'admin_menu', 'boj_multisite_create_menu' );

function boj_multisite_create_menu() {

	// Utworzenie własnego menu najwyższego poziomu.
	add_menu_page( 'Utworzenie witryny w sieci Multisite', 'Utworzenie witryny w sieci Multisite', 'manage_options', 'boj-network-create', 'boj_multisite_create_site_settings' );

}

function boj_multisite_create_site_settings() {
	
	// Sprawdzenie, czy włączono obsługę sieci Multisite.
	if ( is_multisite() ) {
	
		// Jeżeli formularz został wysłany, wówczas należy go przetworzyć.
		if ( isset( $_POST['create_site'] ) ) {	
		
			// Ustawienie wartości zmiennych na podstawie wartości podanych w formularzu.
			$domain = esc_html( $_POST['domain'] );
			$path = esc_html( $_POST['path'] );
			$title = esc_html( $_POST['title'] );
			$user_id = absint( $_POST['user_id'] );
			
			// Sprawdzenie, czy wymagane wartości zostały ustawione.
			if ( $domain && $path && $title && $user_id ) {
			
				// Utworzenie nowej witryny na platformie WordPress.
				$new_site = wpmu_create_blog( $domain, $path, $title, $user_id );
				
				// Wyświetlenie komunikatu w przypadku operacji zakończonej sukcesem.
				if ( $new_site ) {
				
					echo '<div class="updated">Nowa witryna ' .$new_site. ' została utworzona z powodzeniem!</div>';
				
				}
			
			// Wyświetlenie komunikatu błędu, jeśli wymagane wartości nie zostały ustawione.	
			} else {
			
				echo '<div class="error">Nowa witryna nie mogła zostać utworzona. Nie podano wymaganych wartości!</div>';
			
			}
		
		}
		?>
        <div class="wrap">
        	<h2>Tworzenie nowej witryny</h2>
			<form method="post">
            <table class="form-table">
            <tr valign="top"> 
                <th scope="row"><label for="fname">Domena</label></th> 
                <td><input maxlength="45" size="25" name="domain" value="<?php echo DOMAIN_CURRENT_SITE; ?>" /></td> 
            </tr>
            <tr valign="top"> 
                <th scope="row"><label for="fname">Ścieżka dostępu</label></th> 
                <td><input maxlength="45" size="10" name="path" /></td> 
            </tr>
            <tr valign="top"> 
                <th scope="row"><label for="fname">Tytuł</label></th> 
                <td><input maxlength="45" size="25" name="title" /></td> 
            </tr>
            <tr valign="top"> 
                <th scope="row"><label for="fname">Identyfikator użytkownika</label></th> 
                <td><input maxlength="45" size="3" name="user_id" /></td> 
            </tr>
            <tr valign="top"> 
                <td>
                <input type="submit" name="create_site" value="Utwórz witrynę" class="button-primary" /> 
                <input type="submit" name="reset" value="Wyczyść" class="button-secondary" />
                </td> 
            </tr>
            </table>
			</form>
        </div>
		<?php
	} else {
	
		echo '<p>Obsługa sieci Multisite nie została włączona.</p>';
	
	}
	
}
?>
