<?php
/*
Plugin Name: Lista sklepów
Plugin URI: http://przyklad.pl/
Description: Dodanie reguł przepisywania adresów w celu wyświetlenia listy sklepów jako elementów nadrzędnych strony Sklepy.
Version: 1.0
Author: Ozh
Author URI: http://wrox.com
*/

// Dodanie reguły zmiany adresów oraz wyczyszczenie listy podczas aktywacji wtyczki.
register_activation_hook( __FILE__, 'boj_rrs_activate' );
function boj_rrs_activate() {
    boj_rrs_add_rules();
    flush_rewrite_rules();
}

// Wyczyszczenie reguł zmiany adresów podczas dezaktywacji wtyczki.
register_deactivation_hook( __FILE__, 'boj_rrs_deactivate' );
function boj_rrs_deactivate() {
    flush_rewrite_rules();
}

// Dodanie reguł.
add_action( 'init', 'boj_rrs_add_rules' );
function boj_rrs_add_rules() {
    add_rewrite_rule( 'sklepy/?([^/]*)',
        'index.php?pagename=sklepy&store_id=$matches[1]', 'top' );
}

// Dodanie zmiennej store_id, aby była rozpoznawana przez platformę WordPress.
add_filter( 'query_vars', 'boj_rrs_add_query_var' );
function boj_rrs_add_query_var( $vars ) {
    $vars[] = 'store_id';
    return $vars;
}
