<?php
/*
Plugin Name: Punkt końcowy format
Plugin URI: http://przyklad.pl/
Description: Dodaje punkt końcowy /format/ do wszystkich adresów URL.
Version: 1.0
Author: Ozh
Author URI: http://wrox.com
*/


// Dodanie struktury odnośników bezpośrednich oraz wyczyszczenie reguł zmiany adresów podczas aktywacji wtyczki.
register_activation_hook( __FILE__, 'boj_ep_activate' );
function boj_ep_activate() {
    boj_ep_add_rules();
    flush_rewrite_rules();
}

// Wyczyszczenie reguł zmiany adresów podczas dezaktywacji wtyczki.
register_deactivation_hook( __FILE__, 'boj_ep_deactivate' );
function boj_ep_deactivate(){
    flush_rewrite_rules();
}


// Dodanie reguły zmiany adresów, która obsługuje punkty końcowe.
add_filter( 'init', 'boj_ep_add_rules' );
function boj_ep_add_rules() {
    add_rewrite_endpoint( 'format', EP_ALL );
}

// Obsługa własnego formatu wyświetlania, o ile zachodzi taka potrzeba.
add_filter( 'template_redirect', 'boj_ep_template_redirect' );
function boj_ep_template_redirect() {
    switch( get_query_var( 'format' ) ) {
        case 'qr':
            boj_ep_display_qr();
            exit;
        case 'json':
            if( is_singular() ) {
                boj_ep_display_json();
                exit;
            }
    }
}

// Wyświetlenie informacji JSON dotyczących wpisu bloga.
function boj_ep_display_json() {
    global $post;
    header('Content-type: application/json');
    echo json_encode( $post );
    exit;
}

// Wyświetlenie kodu QR.
function boj_ep_display_qr() {
    // Pobranie bieżącego adresu i usunięcie z niego fragmentu /format/qr/.
    $url = ( is_ssl() ? 'https://' : 'http://' )
        . $_SERVER['HTTP_HOST']
        . preg_replace( '!/format/qr/$!', '/', $_SERVER['REQUEST_URI'] );
    
    // Zakodowanie adresu URL, aby mógł być użyty przez zapytanie pobierające kod QR.
    $url = urlencode( $url );
    
    // Adres URL API Google QR Code:
    $qr = "http://chart.apis.google.com/chart?chs=150x150&cht=qr&chl="
        . $url . "&chld=L|0";
    
    // Pobranie obrazu wygenerowanego przez Google.
    $image = wp_remote_retrieve_body( wp_remote_get( $qr ) );

    // Wyświetlenie obrazu zawierającego kod QR.
    header( 'Content-Type: image/png' );
    echo $image;
    exit;
}
?>

