<?php
/*
Plugin Name: Przykład ustawień dla poszczególnych użytkowników
Plugin URI: http://przyklad.pl/
Description: Wtyczka pozwala na wybór języka używanego na stronach administracyjnych: angielski lub polski.
Author: WROX
Author URI: http://wrox.com
*/

// Pobranie ustawień lokalnych użytkownika.
function boj_adminlang_set_user_locale() {
	$user = wp_get_current_user();
	$userid = $user->ID;
	$locale = get_user_meta( $userid, 'boj_adminlang_lang', true );
	return $locale;
}
// Poniższa funkcja będzie wywołana za każdym razem, gdy platforma WP sprawdza wartość ustawień lokalnych.
add_filter( 'locale', 'boj_adminlang_set_user_locale' );

// Dodanie i wypełnienie dodatkowego pola danych wejściowych w profilu użytkownika.
function boj_adminlang_display_field( $user ) {

	$userid = $user->ID;
	$lang = get_user_meta( $userid, 'boj_adminlang_lang', true );
	
	?>
	<tr>
		<th scope="row">Język</th>
		<td>
			<select name="boj_adminlang_lang">
				<option value="" <?php selected( '', $lang); ?>>angielski</option>
				<option value="pl_PL" <?php selected( 'pl_PL', $lang); ?>>polski</option>
			</select>
		</td>
	</tr>
	<?php
}
add_action( 'personal_options', 'boj_adminlang_display_field' );

// Monitorowanie wysłania formularza i uaktualnienie ustawień użytkownika w odpowiedni sposób.
function boj_adminlang_update_field( $userid ) {
	if( isset( $_POST['boj_adminlang_lang'] ) ) {
		$lang = $_POST['boj_adminlang_lang'] == 'pl_PL' ? 'pl_PL' : '';
		update_user_meta( $userid, 'boj_adminlang_lang', $lang );
	}
}
add_action( 'personal_options_update', 'boj_adminlang_update_field' );


