<?php 
/*
Plugin Name: Przykład wtyczki tworzącej widget RSS kokpitu
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka tworząca widget kokpitu na platformie WordPress
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_action( 'wp_dashboard_setup', 'boj_dashboard_example_widgets' );

function boj_dashboard_example_widgets() {

	// Utworzenie własnego widgetu kokpitu.
	wp_add_dashboard_widget( 'dashboard_custom_feed', 'Informacje o wtyczce', 'boj_dashboard_example_display', 'boj_dashboard_example_setup' );
	
}
 
function boj_dashboard_example_setup() {

	// Sprawdzenie przed zapisaniem czy opcja została ustawiona.
	if ( isset( $_POST['boj_rss_feed'] ) ) {
		// Pobranie wartości opcji z formularza.
		$boj_rss_feed = esc_url_raw( $_POST['boj_rss_feed'] );
		
		// Zapisanie wartości jako opcji.
		update_option( 'boj_dashboard_widget_rss', $boj_rss_feed );
	}
 
 	// Wczytanie i zapisanie wiadomości RSS, o ile istnieją.
	$boj_rss_feed = get_option( 'boj_dashboard_widget_rss ');
	
	?>
    <label for="feed">
        Adres URL kanału RSS: <input type="text" name="boj_rss_feed" id="boj_rss_feed" value="<?php echo esc_url( $boj_rss_feed ); ?>" size="50" />
    </label>
	<?php
}
 
function boj_dashboard_example_display()
{
	// Wczytanie opcji widgetu.
	$boj_option = get_option( 'boj_dashboard_widget_rss ');
	
	// Jeżeli opcje nie zostały ustawione, wówczas należy użyć domyślnych.
	$boj_rss_feed = ( $boj_option ) ? $boj_option : 'http://wordpress.org/news/feed/';
	
	// Pobranie wiadomości RSS i ich wyświetlenie.
	echo '<div class="rss-widget">';
	
	wp_widget_rss_output( array(
		'url' => $boj_rss_feed,
		'title' => 'Wiadomości RSS',
		'items' => 2,
		'show_summary' => 1,
		'show_author' => 0,
		'show_date' => 1 
	) );
	
	echo '</div>';	
}
?>
