<?php

add_filter( 'posts_results', 'boj_custom_home_page_posts' );

function boj_custom_home_page_posts( $results ) {
    global $wpdb, $wp_query;

    /* Sprawdzenie czy wywietlana jest strona gwna. */
    if ( is_home() ) {
				
				/* Posty na stronie. */
        $per_page = get_option( 'posts_per_page' );
				
				/* Pobranie biecej strony */
        $paged = get_query_var( 'paged' );
				
				/* Ustawienie zmiennej $page. */
        $page = ( ( 0 == $paged || 1 == $paged ) ? 1 : absint( $paged ) );
				
				/* Okrelenie liczby postw. */
        $offset = ( $page - 1 ) * $per_page . ', ';
				
				/* Okrelenie ograniczenia zmiennej $offset oraz liczby wywietlanych postw. */
        $limits = 'LIMIT '. $offset . $per_page;
				
				/* Pobranie wynikw z bazy danych. */
        $results = $wpdb->get_results( "
            SELECT SQL_CALC_FOUND_ROWS $wpdb->posts.* 
            FROM $wpdb->posts 
            WHERE 1=1 
            AND post_type = 'page' 
            AND post_status = 'publish' 
            ORDER BY post_title ASC 
            $limits
        " );
    }

    return $results;
}

?>
