<?php 
/*
Plugin Name: Wyświetlenie zadań cron
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka demonstrująca użycie cron na platformie WordPress.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

add_action( 'admin_menu', 'boj_view_cron_menu' );

function boj_view_cron_menu() {

	// Utworzenie strony ustawień wtyczki wyświetlającej zadania cron.
    add_options_page( 'Wyświetl zadania Cron', 'Wyświetl zadania Cron', 'manage_options', 'boj-view-cron', 'boj_view_cron_settings' );
	
}

function boj_view_cron_settings() {

	$cron = _get_cron_array();
	$schedules = wp_get_schedules();
	$date_format = 'j M Y @ G:i';
	?>
	<div class="wrap" id="cron-gui">
	<h2>Zadania harmonogramu</h2>
    
	<table class="widefat fixed">
		<thead>
			<tr>
				<th scope="col">Kolejne uruchomienie zadania (GMT/UTC)</th>
				<th scope="col">Częstotliwość uruchamiania</th>
				<th scope="col">Nazwa zaczepu</th>
			</tr>
		</thead>
		<tbody>
			<?php foreach ( $cron as $timestamp => $cronhooks ) { ?>
				<?php foreach ( (array) $cronhooks as $hook => $events ) { ?>
					<?php foreach ( (array) $events as $event ) { ?>
						<tr>
							<td>
								<?php echo date_i18n( $date_format, wp_next_scheduled( $hook ) ); ?>
                            </td>
							<td>
								<?php 
								if ( $event[ 'schedule' ] ) {
									echo $schedules[ $event[ 'schedule' ] ][ 'display' ]; 
								} else {
									?>Jednorazowe<?php
								}
								?>
							</td>
							<td><?php echo $hook; ?></td>
						</tr>
					<?php } ?>
				<?php } ?>
			<?php } ?>
		</tbody>
	</table>
    </div>
<?
}
?>
