<?php 
/*
Plugin Name: Usunięcie wersji wpisów bloga 
Plugin URI: http://przyklad.pl/wtyczki-wordpress/moja-wtyczka
Description: Wtyczka demonstrująca użycie cron na platformie WordPress.
Version: 1.0
Author: Brad Williams
Author URI: http://wrox.com
License: GPLv2
*/

// Utworzenie własnego zaczepu dla zadania harmonogramu.
add_action('boj_del_rev_cron_hook', 'boj_cron_rev_delete');

function boj_cron_rev_delete() {
	global $wpdb;
	
	// Wygenerowanie zapytania przeznaczonego do usunięcia wersji wpisów bloga starszych niż 30 dni.
	$sql = "DELETE a,b,c  
		FROM $wpdb->posts a  
		LEFT JOIN $wpdb->term_relationships b ON (a.ID = b.object_id)  
		LEFT JOIN $wpdb->postmeta c ON (a.ID = c.post_id)  
		WHERE a.post_type = 'revision' 
		AND DATEDIFF( now(), a.post_modified ) > 30 ";

	// Wykonanie zapytania i usunięcie wszystkich starych wersji bloga oraz powiązanych z nimi metadanych.
	$wpdb->query( $wpdb->prepare( $sql ) );

}

add_action('admin_init', 'boj_cron_rev_admin_init');

function boj_cron_rev_admin_init(){

	// Rejestracja opcji za pomocą API Settings.
	register_setting(
		'general', 
		'boj_cron_rev_options' 
	);
	
	// Rejestracja pola za pomocą API Settings.
	add_settings_field(
		'boj_cron_rev_field',
		'Usunąć co tydzień starsze wersje wpisów bloga?',
		'boj_cron_rev_setting_input',
		'general',
		'default'
	);

	// Wczytanie wartości opcji.
	$options = get_option( 'boj_cron_rev_options' );
	$boj_del_rev = $options['boj_del_rev'];
	
	// Jeżeli opcja jest włączona, ale nie zdefiniowano zadania harmonogramu to teraz trzeba dodać odpowiednie  zadanie.
	if ( $boj_del_rev == 'on' && !wp_next_scheduled( 'boj_del_rev_cron_hook' ) ) {
	
		// Zadanie będzie wykonywane co godzinę.
		wp_schedule_event( time(), 'weekly', 'boj_del_rev_cron_hook' );
		
	// Jeżeli opcja NIE jest włączona i zdefiniowano zadanie, trzeba je usunąć z harmonogramu.
	} elseif ( $boj_del_rev != 'on' && wp_next_scheduled( 'boj_del_rev_cron_hook' ) ) {
	
		// Pobranie godziny następnego uruchomienia zadania.
		$timestamp = wp_next_scheduled( 'boj_del_rev_cron_hook' );
		
		// Wyrejestrowanie własnego zaczepu akcji.
		wp_unschedule_event( $timestamp, 'boj_del_rev_cron_hook' );

	}

}

function boj_cron_rev_setting_input() {

	// Wczytanie z bazy danych opcji 'boj_del_rev'.
	$options = get_option( 'boj_cron_rev_options' );
	$boj_del_rev = $options['boj_del_rev'];

	echo "<input id='boj_del_rev' name='boj_cron_rev_options[boj_del_rev]' type='checkbox' ". checked( $boj_del_rev, 'on', false ). " />";
	
}

// Uruchamianie zadania raz w tygodniu.
add_filter( 'cron_schedules', 'boj_cron_add_weekly' ); 

function boj_cron_add_weekly( $schedules ) {

	// Utworzenie częstotliwości 'weekly', czyli raz w tygodniu.
	$schedules['weekly'] = array(
		'interval' => 604800,
		'display' => 'Raz w tygodniu'
	);
	
	return $schedules;
}

?>
